<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Favorite extends Model 
{

    protected $table = 'favorites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'dream_id');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function dream()
    {
        return $this->belongsTo('App\Models\Dream');
    }

}